define([
    'underscore',
    'Vent',
    'modules/page/popup/warning-popup-view',
    'modules/loading-spinner/loading-spinner',
    'text!modules/connection/session-warning.html',
],
function (_, vent, WarningPopupView, loadingSpinner, template) {
    'use strict';

    return WarningPopupView.extend({
        id: 'session-warning',
        template: _.template(template),
        ui: {'heading': '.ui-title'},
        events: {
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click .warning-continue-btn': 'logout', // #session-logout-btn
            'click .warning-return-btn': 'resetSession', // #session-continue-btn
            'click button': 'closePopup',
        },
        modelEvents: {'change:sessionTimeoutIn': 'updateTime'},
        updateTime: function() {
            this.ui.heading.text(this.model.get('sessionTimeoutIn'));
        },
        logout: function(e) {
            vent.trigger('do:logout', e);
        },
        resetSession: function() {
            loadingSpinner.radio.once('show', function() {
                loadingSpinner.radio.once('hide', function() {
                    this.focusOnElAfterClose();
                }, this);
            }, this);
            vent.trigger('do:session:refresh');
            // from session refresh, ajax call is made
        },
    });
});
